#import <Cocoa/Cocoa.h>

#define MAXSOUNDS 8

@interface DrumMachine : NSObject
{
    int trigger[MAXSOUNDS][16];
    int cursor;
    int playing;
    int tempo;
    
    NSTimer* timer;
    int timer_tempo;  // the tempo the timer was set for
}
- init;
- (int)trigger: (int)n withSound: (int)s;
- setTrigger: (int)n withSound: (int)s to:(int)t;
- toggleTrigger: (int)n withSound: (int)s;
- (int)tempo;
- setTempo: (int)t;
- (int)cursor;
- setCursor:(int)c;
- start;
- stop;
- (int)playing;
- (int)numSounds;
- (NSString*)soundNameAt:(int)index;
- timerTick:(NSTimer)timer;
@end
