#import "DrumMachine.h"

static NSString* sound_names[] = { @"606bd", @"606sd", @"606ch", @"606oh", @"606ride", @"606ht", @"606lt" };
#define NSOUNDS (sizeof(sound_names)/sizeof(sound_names[0]))
static NSSound* sounds[NSOUNDS];

@implementation DrumMachine
- init
{
  register int i,j;
  for(i=0; i<NSOUNDS; i++) 
    for(j=0; j<16; j++) 
      trigger[i][j]=0;
  cursor = 0;
  playing = 0;
  tempo = 120;
  for(i=0; i<NSOUNDS; i++)
    sounds[i] = [NSSound soundNamed:sound_names[i]];
  return self;
}

- (int)trigger: (int)n withSound: (int)s
{
  return trigger[s][n];
}

- setTrigger: (int)n withSound: (int)s to:(int)t
{
  trigger[s][n]=t;
  return self;
}

- toggleTrigger: (int)n withSound: (int)s
{
  trigger[s][n] = !trigger[s][n];
  return self;
}
- (int)tempo
{
  return tempo;
}
- setTempo: (int)t
{
  tempo = t;
  return self;
}
- (int)cursor
{
    return cursor;
}

- setCursor:(int)c
{
    cursor = c;
    return self;
}

- start
{
  double secs_per_tick = 60.0/(tempo*4);
  timer = [NSTimer scheduledTimerWithTimeInterval:secs_per_tick target:self selector:@selector(timerTick:)
    userInfo: Nil repeats: TRUE];
  timer_tempo = tempo;
  playing = 1;
  return self;
}
- stop
{
  [timer invalidate];
//  [timer autorelease];
  playing = 0;
  return self;
}

- (int)playing
{
  return playing;
}

- (int)numSounds
{
    return NSOUNDS;
}
- (NSString*)soundNameAt:(int)index
{
    return sound_names[index];
}

- timerTick:(NSTimer)t
{
  int i;
  // first stop any open hats if a closed hat is to be triggered
  if(trigger[2][cursor] && [sounds[3] isPlaying])
    [sounds[3] stop];
  for(i=0; i<NSOUNDS; i++)
    if (trigger[i][cursor])  [sounds[i] play];
//  [sounds[2] play];
  cursor = (cursor+1)%16;
  // now we check if the tempo has changed, and if so, reset
  // the timer
  if(timer_tempo != tempo) {
    double secs_per_tick = 60.0/(tempo*4);
    [timer invalidate];
    timer = [NSTimer scheduledTimerWithTimeInterval:secs_per_tick
      target:self selector:@selector(timerTick:)
      userInfo: Nil repeats: TRUE];
    timer_tempo = tempo;
  }
  return self;
}

@end
