#import "DrumMachineController.h"
#include <stdio.h>

@implementation DrumMachineController

- (void)awakeFromNib
{
  int i, n=[drumMachine numSounds];
  NSArray* subviews;
  NSEnumerator* en;
  id control;
  [soundSelector removeAllItems];
  for(i=0; i<n; i++)
    [soundSelector addItemWithTitle:[drumMachine soundNameAt:i]];
    
  // here we loop through the main window's subviews to find all 
  // the checkboxes for the step sequencer and put them into
  // the checkbox array.  This saves us from having separate
  // IBOutlet variables for all of them and ugly, laborious 
  // case statements or similar bogosities to select them.
  subviews = [[uiWindow contentView] subviews];
  //printf("content view has %u subviews\n", [subviews count]);
  en = [subviews objectEnumerator];
  while(control = [en nextObject]) {
    if([[control className] isEqualToString:@"NSButton"]) {
        int tag = [control tag];
        if (tag >= 0 && tag < 16)
            checkbox[tag] = control;
    }
  }
  // uncomment for a somewhat silly-looking transparent drum machine
  //[uiWindow setAlphaValue:0.5];
}

- (IBAction)toggleCheckBox:(id)sender
{
//  printf("toggleCheckBox: tag = %d\n", [sender tag]);
  int snd = [soundSelector indexOfSelectedItem];
  int num = [sender tag];
  [drumMachine setTrigger:num withSound:snd to:([checkbox[num] state])==NSOnState];
}

- (IBAction)togglePlay:(id)sender
{
  if ([drumMachine playing]) {
    [drumMachine stop];
    [sender setTitle:@"Start"];
  } else {
    [drumMachine start];
    [sender setTitle:@"Stop"];
  }
}

- (IBAction)soundChanged:(id)sender
{
  int i;
  int selected = [soundSelector indexOfSelectedItem];
  for(i=0; i<16; i++) {
    int tr = [drumMachine trigger:i withSound:selected];
//    printf("Checkbox %d state = %d\n", i, [checkbox[i] state]);
    [checkbox[i] setState:(tr?NSOnState:NSOffState)];
  }
}

- (IBAction)tempoChanged:(id)sender
{
    int newtempo = [bpmStepper intValue];
    [bpmDisplay setIntValue:newtempo];
    [drumMachine setTempo:newtempo];
}


@end
