#!/usr/bin/env python
# a simple multi-threaded port forwarder, to allow access from  VMware or 
# a local private network to various TCP/IP servers on a wider network.
# Tested on Wintendo NT 4.0
# author: acb   23/5/2001
# v0.1

import thread
from socket import *
from select import select

# this is our VMware host-only network interface
listen_iface = '192.168.183.1'

# the mappings, in the form (destaddr,destport):listenport

mappings = {
  ('webproxy.example.com',8080):3128,
  ('smbserver.example.com',139):1139
}

# do we use Tk?
TK = 1

if TK:
  from Tkinter import *


  def updateLB():
    "Update the listbox showing connections"
    lbox.delete(0, END)
    for c in connections:
      lbox.insert(END, str(c))

  root = Tk()
  root.title("Redirected TCP/IP connections")
  lbox = Listbox(root)
  lbox.pack(fill="x")
  thread.start_new(root.mainloop, ())

insock = {}
insocks = []
sockdest = {}
connections = []
conn_lock = thread.allocate_lock()

for addr,port in mappings.keys():
  ins = socket(AF_INET, SOCK_STREAM)
  ins.bind((listen_iface, mappings[(addr,port)]))
  insocks.append(ins)
  insock[(addr,port)] = ins
  sockdest[ins] = (addr,port)
  ins.listen(5)

def handleConnection(ins,outs):
  "A thread handling a single incoming connection."
  if not TK: 
    print "Opening connection from ", ins.getpeername(), " to ", outs.getpeername()
  connectionname = "%s:%d -> %s:%d"%(ins.getpeername()+outs.getpeername())
  conn_lock.acquire()
  #connections.append((ins.getpeername(), outs.getpeername()))
  connections.append(connectionname)
  if TK: updateLB()
  conn_lock.release()
  partner = { ins:outs, outs:ins }
  bored = 0
  while not bored:
    readable,writable,exc = select([ins,outs],[],[])
    for sock in readable:
      received = sock.recv(2048)
      if not received: bored = 1
      partner[sock].send(received)
  if not TK:
    print "Closing connection from ", ins.getpeername(), " to ", outs.getpeername()
  conn_lock.acquire()
  connections.remove(connectionname)
  if TK: updateLB()
  conn_lock.release()
  outs.close()
  ins.close()
  

def acceptConnection(sock):
  "Accepts a connection on a socket, spawning a handler thread"
  conn,addr = sock.accept()
  outsock = socket(AF_INET, SOCK_STREAM)
  outsock.connect(sockdest[sock])
  thread.start_new(handleConnection, (conn,outsock))


while 1:
  r,w,x = select(insocks, [], [])
  for incoming in r:
    acceptConnection(incoming)

