#!/usr/bin/python

"""extract sprite images from a X64 memory dump, writing them to a pixmap,
whence they can be extracted."""

import getopt, sys

import Image


class FmtError:
  pass

def processSprite(data,img,xoff,yoff,colour):
  values = (0, 128, 192, 255)
 
  if colour:
    pixwidth = 2
    leftval = lambda byte:(byte&0xc0)>>6
  else:
    pixwidth = 1
    # map the MSB to (0,3)
    leftval = lambda byte:((byte&0x80)>>7)*3

  for line in range(0,21):
    for col in range(0,3):
      c = ord(data[(line*3+col)])
      for pix in range(0,8,pixwidth):
        val = leftval(c)
	c = c<<pixwidth
	for d in range(0,pixwidth):
	  img.putpixel((xoff+(col*8)+pix+d,yoff+line), values[val])

def processBank(bdata, colour, verbosity):
  img = Image.new('L', (16*24, 16*21))
  for sprite in range(0,256):
    if verbosity>1:
      sys.stdout.write("sprite %03d\015"%sprite)
      sys.stdout.flush()
    sdata = bdata[sprite*64:(sprite+1)*64]
    processSprite(sdata,img,(sprite%16)*24,int(sprite/16)*21, colour)
  return img

def processFile(fn, colour, verbosity):
  imgs = []
  f = open(fn,'r')
  # we assume that in the VICE snapshot format, the memory dump header 
  # starts 0x66 bytes into it.
  f.seek(0x66, 0)
  if f.read(6) != 'C64MEM':
    raise FmtError, "C64MEM doesn't appear where expected"
  f.seek(20,1)
  # now we have 64K to process
  for bank in range(0,4):
    if verbosity>0:
      print "processing bank %d:"%bank
    bdata = f.read(16384)
    imgs.append(processBank(bdata, colour, verbosity))
  return imgs

opts,args = getopt.getopt(sys.argv[1:], 'mo:v', ['mono','output='])

if not args:
	sys.exit("usage: %s [-m] [-o fn] [-v] memorydump"%sys.argv[0])

colour = True
outfn = 'sprites.pgm'
verbosity = 0
for o,a in opts:
  if o in ('-m', '--mono'): colour=False
  if o in ('-o', '--output'): outfn = a
  if o == '-v': verbosity += 1

imgs = processFile(args[0], colour, verbosity)

for n,img in enumerate(imgs):
  of = open("%s.%d"%(outfn,n),'w')
  img.save(of, 'ppm')
  of.close()
